require("dotenv").config();
const express = require("express");
const mongoose = require("mongoose");
const cors = require("cors");

mongoose.connect(process.env.MONGO_URI)
    .then(() => console.log("MongoDB Connected"));

const app = express();
app.use(cors());
app.use(express.json());

app.use("/api/forms", require("./routes/form"));
app.use("/api/responses", require("./routes/response"));

app.listen(5000, () => console.log("Server running on 5000"));
